// 'use client'
import styles from './globals.css';
// import { useEffect, useState } from 'react
import Preloader from '@/components/perAnimation';
// Testimonials


// import Banner from '@/components/Banner';
import { Navbar } from '@/components/Navbar';
// import Image from 'next/image';
import Aboutus from '@/components/Aboutus';
import ServiceBox from '@/components/ServiceBox';
// import Testimonials from '@/components/Testimonials';
import Contact from '@/components/Contact';
import Footer from '@/components/Footer';
import { Banner, Testimonials } from '@/components/share';
// import Head from 'next/head';

export const metadata = {
  title: "Toni & Guy - Premier Hair and Beauty Salon in Kolathur, Chennai",
  description: "Discover exceptional hair and beauty services at Toni & Guy Kolathur. We offer a range of unisex services, including haircuts, treatments, bridal styling, and more.",
  keywords: "Toni & Guy, hair salon, beauty services, Kolathur, Chennai, haircuts, hair treatments, bridal services, unisex beauty",
  author: "Toni & Guy Kolathur",
  openGraph: {
    title: "Toni & Guy - Premier Hair and Beauty Salon in Kolathur, Chennai",
    description: "Experience top-tier hair and beauty services in a welcoming atmosphere.",
    url: "https://yourwebsite.com/", // Update this to your actual website
    siteName: "Toni & Guy Kolathur",
    images: [
      {
        url: "/images/your-image.jpg", // Replace with a relevant image for social sharing
        width: 800,
        height: 600,
        alt: "Toni & Guy Salon in Kolathur"
      }
    ],
    type: "website",
  },
};

export default function Home() {


  return (
    <>
      {/* <Head>
        <title>Toni & Guy - Premier Hair and Beauty Salon in Kolathur, Chennai</title>
        <meta name="description" content="Discover exceptional hair and beauty services at Toni & Guy Kolathur. We offer a range of unisex services, including haircuts, treatments, bridal styling, and more." />
        <meta name="keywords" content="Toni & Guy, hair salon, beauty services, Kolathur, Chennai, haircuts, hair treatments, bridal services, unisex beauty" />
        <meta name="author" content="Toni & Guy Kolathur" />
        <link rel="canonical" href="https://toniandguykolathur.com/" />
      </Head> */}

      <main className={styles.main}>
        <Navbar />
        <Preloader />
        <Banner />

        <div className="container mx-auto px-4 py-10 my-10 text-black">
          {/* Welcome Section */}
          <div className="text-center mb-12">
            <h1 className="lg:text-6xl md:text-5xl text-4xl font-extrabold mb-6 text-black" style={{ letterSpacing: '-2px' }}>
              Welcome to Toni & Guy <br /> Kolathur, Chennai
            </h1>
            <p className="text-xl text-gray-500">Your Destination for Unisex Beauty Excellence</p>
          </div>


          {/* <div className='container mx-auto'>
            <div>
              <Image src={''}></Image>
            </div>    </div>
 */}

          <Aboutus />
          <ServiceBox />
        </div>

        <div className='w-screen  bg-cover' style={{ backgroundImage: "url(/images/2.jpeg)" }}>

          <div className='lg:text-6xl md:text-4xl sm:text-2xl text-xl py-16 font-extrabold text-white text-center bg-[rgba(0,0,0,0.6)]  flex h-[500px] justify-center items-center'>Elevate Your Style, Embrace the Essence of You</div>

        </div>

        <div className="container mx-auto px-4 py-10 my-10 text-black">
          <Testimonials />
        </div>


        <div className='w-screen  bg-gray-100' >



          <Contact />
        </div>


        <Footer />
      </main>
    </>
  );
}
