import Image from 'next/image';
import React from 'react'

export default function Index() {
    return (
        <div className="flex flex-col md:flex-row items-center p-6 md:p-12 gap-16 ">
            <div data-aos="fade-right" className="w-full md:w-1/2 mb-6 md:mb-0">
                <Image
                    width={300}
                    height={300}
                    src={"/images/about.jpeg"}
                    alt="Toni & Guy Salon"
                    className="w-full shadow-lg"
                />
            </div>
            <div data-aos="fade-left" className="w-full md:w-1/2 md:pl-8 text-center md:text-left">
                <h2 className="text-4xl font-extrabold  text-black mb-4 uppercase pb-10" style={{ letterSpacing: '-4px' }}>About Us</h2>
                <p className="text-black italic font-medium mb-4">
                    Welcome to Toni & Guy, Kolathur, Chennai! We are a proud franchise of the globally recognized Toni & Guy brand, offering world-class hairdressing and beauty services in the heart of Kolathur. Our salon provides the latest trends in hairstyling, cutting, coloring, and a range of beauty treatments to rejuvenate and enhance your natural beauty.
                </p>
                <p className="text-black italic font-medium mb-4">
                    With a team of expert stylists and beauty professionals, we are dedicated to delivering personalized care, ensuring a refreshing and luxurious experience for each client. Whether you're here for a hairstyle transformation or a beauty treatment, our services are designed to bring out the best in you.
                </p>
                <p className="text-black italic font-medium">
                    Toni & Guy Essensuals has evolved since 1997, expanding globally with a unique “Diffusion line” that combines classic hairdressing with innovative beauty services. Experience why Toni & Guy is trusted worldwide, right here in Chennai.
                </p>

            </div>
        </div>
    );
}
