"use client";
import React, { useEffect, useState } from "react";
import { Swiper, SwiperSlide } from "swiper/react";

// Import Swiper styles
import "swiper/css";
import "swiper/css/effect-fade";
import "swiper/css/navigation";
import "swiper/css/pagination";

// Import required modules
import { Autoplay, EffectFade } from "swiper/modules";
import Image from "next/image";

import { motion } from "framer-motion";


export default function Index() {

  const [show, setShow] = useState(false);

  useEffect(() => {
    setTimeout(
      () => {
        setShow(true);
      }, 1000
    )
  });

  return (
    <motion.div initial={{ opacity: 0 }} animate={{ opacity: show ? 1 : 0 }} transition={{ duration: 0.7 }} className="relative w-screen mt-20 md:mt-0">
      <motion.div
        className="lg:text-7xl md:text-6xl sm:text-4xl text-3xl text-white font-extrabold absolute bottom-20 z-10 start-0 end-0 text-center"
        initial={{ opacity: 0, y: 20 }} // Start off transparent and slightly down
        animate={{ opacity: 1, y: 0 }} // Fade in and move to original position
        exit={{ opacity: 0, y: 20 }} // Fade out and move down
        transition={{ duration: 0.5 }} // Duration of the animation
      >
        Where Style Becomes Art.
      </motion.div>
      <Swiper
        spaceBetween={30}
        effect={"fade"}
        loop={true}
        autoplay={{ delay: 5000 }}
        modules={[EffectFade, Autoplay]}
      >
        <SwiperSlide>
          <div className="relative w-full lg:h-screen h-[450px] sm:h-[750px] md:[calc(90vh)]"> {/* Set height to 100vh for full height */}
            <Image
              src="/banner/1 (1).jpg"
              alt="Banner 1"
              fill


              style={{ objectFit: "cover", objectPosition: 'top' }}
              priority
            />
          </div>
        </SwiperSlide>
        <SwiperSlide>
          <div className="relative w-full lg:h-screen h-[450px] sm:h-[750px] md:[calc(90vh)]"> {/* Full height */}
            <Image
              src="/banner/2.jpg"
              alt="Banner 2"
              fill

              style={{ objectFit: "cover", objectPosition: 'top' }}
              priority
            />
          </div>
        </SwiperSlide>
        <SwiperSlide>
          <div className="relative w-full lg:h-screen h-[450px] sm:h-[750px] md:[calc(90vh)]"> {/* Full height */}
            <Image
              src="/banner/3.jpg"
              alt="Banner 3"
              fill

              style={{ objectFit: "cover", objectPosition: 'top' }}
              priority
            />
          </div>
        </SwiperSlide>
      </Swiper>
    </motion.div>
  );
}
