"use client";

import * as React from "react";
import { motion } from "framer-motion";
import { MenuItem } from "./MenuItem";
import style from "./styles.css";

const variants = {
  open: {
    transition: { staggerChildren: 0.07, delayChildren: 0.2 },
  },
  closed: {
    transition: { staggerChildren: 0.05, staggerDirection: -1 },
  },
};

export const Navigation = () => (
  <motion.ul
    style={{
      padding: '25px',
      position: 'absolute',
      top: '100px',
      width: '230px',
    }}
    variants={variants}
  >
    {itemIds.map(({ i, title, link }) => (
      <MenuItem i={i} link={link} title={title} key={i} />
    ))}
  </motion.ul>
);
const itemIds = [
  { i: 0, title: 'About', link: '/about' }, // Added title for About
  { i: 1, title: 'Services', link: '/services' }, // Added title for Services
  // { i: 2, title: 'Portfolio', link: '/portfolio' }, // Added title for Portfolio
  { i: 2, title: 'Blog', link: '/blog' }, // Added title for Contact
  { i: 3, title: 'Contact', link: '/contact' }, // Added title for Contact
  // { i: 4, title: 'FAQ', link: '/faq' } // Added title for FAQ
];
