'use client'

import * as React from "react";
import { useRef, useEffect } from "react";
import { motion, useCycle } from "framer-motion";
import { useDimensions } from "./use-dimensions";
import { MenuToggle } from "./MenuToggle";
import { Navigation } from "./Navigation";
import style from "./styles.css"; // Make sure to use CSS Modules if needed (styles.module.css)
import Image from "next/image";
import Link from "next/link";


const sidebar = {
    open: (height = 1000) => ({
        clipPath: `circle(${height * 2 + 200}px at 40px 40px)`,
        transition: {
            type: "spring",
            stiffness: 20,
            restDelta: 2
        }
    }),
    closed: {
        clipPath: "circle(10px at 0px 0px)",
        transition: {
            delay: 0.5,
            type: "spring",
            stiffness: 400,
            damping: 40
        }
    }
};

export const Navbar = () => {
    const [isOpen, toggleOpen] = useCycle(false, true);
    const containerRef = useRef(null);
    const { height } = useDimensions(containerRef);// Add empty dependency array to only run on mount

    return (
        <div data-aos="fade" className="fixed md:px-10 px-3 bg-[rgba(250,250,250)] top-0 z-50 w-full flex md:justify-between items-center">
            <div className="w-10">
                <motion.nav
                    style={{
                        position: 'absolute',
                        top: 0,
                        left: 0,
                        bottom: 0,
                        width: '0',
                        zIndex: '-1',
                        height: '100vh'
                    }}
                    initial={false}
                    animate={isOpen ? "open" : "closed"}
                    custom={height}
                    ref={containerRef}
                >
                    <motion.div
                        style={{
                            position: 'absolute',
                            top: 0,
                            left: 0,
                            bottom: 0,
                            width: '300px',
                            background: '#fff'
                        }}
                        variants={sidebar}
                    />
                    <Navigation />
                    <MenuToggle toggle={() => toggleOpen()} />
                </motion.nav>
            </div>
            <Link href="/" className="flex items-center">
                <Image src="/logo.png" height={300} width={350} className="md:w-72 ms-10 md:ms-0 w-60" alt="Site Logo" />
            </Link>
            <Link href="/contact">
                <button className="btn hidden md:block">Book Now</button>
            </Link>
        </div>
    );
};
