"use client";
import styles from "./style.module.scss";
import { useEffect, useState } from "react";
import { motion } from "framer-motion";
import { opacity, slideUp } from "./anim";
import Image from 'next/image';

const words = [
  "Hello",
  "Bonjour",
  "Ciao",
  "Olà",
  "やあ",
  "Hallå",
  "Guten tag",
  "Hallo",
];

export default function Index() {
  const [index, setIndex] = useState(0);
  const [showText, setShowText] = useState(false);
  const [dimension, setDimension] = useState({ width: 0, height: 0 });

  useEffect(() => {
    setDimension({ width: window.innerWidth, height: window.innerHeight });
  }, []);

  useEffect(() => {
    if (!showText) {
      setTimeout(() => {
        setShowText(true);
      }, 700); // Show text after 1 second (1000 ms)
    }
  }, [showText]);

  useEffect(() => {
    if (index == words.length - 1) return;
    if (showText) {
      setTimeout(
        () => {
          setIndex(index + 1);
        },
        index == 0 ? 1000 : 150
      );
    }
  }, [index, showText]);

  const initialPath = `M0 0 L${dimension.width} 0 L${dimension.width} ${dimension.height
    } Q${dimension.width / 2} ${dimension.height + 300} 0 ${dimension.height
    }  L0 0`;
  const targetPath = `M0 0 L${dimension.width} 0 L${dimension.width} ${dimension.height
    } Q${dimension.width / 2} ${dimension.height} 0 ${dimension.height}  L0 0`;

  const curve = {
    initial: {
      d: initialPath,
      transition: { duration: 0.7, ease: [0.76, 0, 0.24, 1] },
    },
    exit: {
      d: targetPath,
      transition: { duration: 0.7, ease: [0.76, 0, 0.24, 1], delay: 0.3 },
    },
  };

  return (
    <motion.div
      variants={slideUp}
      initial="initial"
      exit="exit"
      className={styles.introduction}
    >
      {dimension.width > 0 && (
        <>
          {/* Image fades out after 1 second */}
          <motion.figure
            className={styles.logo}
            initial={{ opacity: 1 }}
            animate={{ opacity: showText ? 0 : 1, display: showText ? 'none' : 'block' }}
            transition={{ duration: 0.5, ease: "circInOut" }}
          >
            <Image
              src='/Toni-Guy-LOGO-removebg-preview.png'
              width={400} // Set desired width in pixels
              height={100} // Set desired height in pixels
              alt='Logo'
              className="w-80 md:w-96"
            />
          </motion.figure>

          {/* Text fades in after the image */}
          {showText && (
            <motion.p variants={opacity} initial="initial" animate="enter">
              <span></span>
              {words[index]}
            </motion.p>
          )}
          <svg>
            <motion.path
              variants={curve}
              initial="initial"
              exit="exit"
            ></motion.path>
          </svg>
        </>
      )}
    </motion.div>
  );
}
