import Link from 'next/link';
import React from 'react';

export default function Index() {
    const services = [
        {
            img: '/images/hair_service.jpg',
            name: 'Hair Services',
            description: 'Experience top-notch hairdressing services in our salon. Our skilled stylists specialize in hairdressing services, offering expert haircuts, stunning colours, and personalised treatments for your unique beauty. From traditional styles to the latest trends, we craft exceptional hairdressing services for you. TONI&GUY: Where Hair Becomes Art.',
            slug: 'haircut-hair-colouring'
        },
        {
            img: '/images/beauty.jpg',
            name: 'Beauty Services',
            description: 'Step into a home of beauty and self-care with our expert services. Rejuvenate with luxurious facials, achieve silky smoothness with our expert waxing, or glam up with our specialized makeup services. Choose from our signature, express, or personalized makeup service to elevate your beauty. Book your session now for a radiant transformation.',
            slug: 'haircut-hair-colouring'
        },
        {
            img: '/images/makeup.jpeg',
            name: 'Makeup Services',
            description: 'Transform your look effortlessly at TONI&GUY. Our skilled makeup artists craft personalised makeup looks, be it a natural radiance or a glamorous aura. Choose from our signature, express, or personalised makeup services. Book your session online and embrace a stunning transformation today!',
            slug: 'haircut-hair-colouring'
        }
    ];

    return (
        <div className="grid lg:grid-cols-3 md:grid-cols-2 grid-cols-1 gap-6 p-4">
            {services.map((service, index) => (
                <Link data-aos="fade-up" data-aos-delay={index * 300} href={`/services/${service.slug}`}
                    key={index}
                    className="relative w-full overflow-hidden shadow-lg"
                    style={{ paddingBottom: '125%' }} // 4:5 aspect ratio
                >
                    <div
                        className="absolute inset-0 bg-cover bg-center hover:scale-105 transition-all"
                        style={{ backgroundImage: `url(${service.img})` }}
                    ><div className="absolute inset-0 bg-gradient-to-t from-black to-transparent"></div>

                        <div className="relative p-6 flex flex-col justify-end items-start h-full text-start text-white">
                            <h3 className="text-2xl font-bold mb-4">{service.name}</h3>
                            <p className="text-sm">{service.description}</p>
                        </div>
                    </div>
                </Link>
            ))}
        </div>
    );
}
