// components/Testimonials.js

import React from 'react';
import { Swiper, SwiperSlide } from 'swiper/react';
import 'swiper/swiper-bundle.css'; // Import Swiper styles
import { Autoplay, Pagination } from 'swiper/modules';

const testimonials = [
  {
    name: "Arjun Kumar",
    review: "As someone who values a good haircut, TONI&GUY has become my trusted grooming partner. What sets them apart is not just their exceptional skill but the way they make you feel. It's like visiting old friends who happen to be incredible barbers. They remember your style preferences, making each visit feel personal and tailored to you. The ambience is relaxing, and the attention to detail is unparalleled. It's not just a haircut; it's an experience that leaves you looking sharp and feeling valued.",
  },
  {
    name: "Anjali Ramesh",
    review: "Every time I step into TONI&GUY, I know I’m in for a treat. The team is not only incredibly talented but also genuinely cares about their clients. From the moment I arrive, I’m greeted with warmth and professionalism. The stylists take the time to understand what I want, offering valuable suggestions based on my hair type and face shape. I’ve walked out of there feeling like a new person every time! The atmosphere is stylish yet cozy, making it a perfect spot to unwind while getting pampered.",
  },
  {
    name: "Ravi Chandran",
    review: "TONI&GUY is where luxury meets skill. I’ve been a loyal customer for years, and I can’t imagine going anywhere else. The staff is not only skilled in their craft but also incredibly attentive. They go above and beyond to ensure that my experience is perfect from start to finish. The range of services they offer is impressive, whether I need a quick trim or a complete makeover. I particularly love the relaxing wash station—it’s a mini spa experience! This salon truly understands what it means to provide top-notch service.",
  },
  // Add more testimonials as needed
];


export default function Index() {
  return (
    <div className="testimonials">
      <h2 className="font-extrabold text-center mb-4 text-5xl uppercase">What Our Clients Say</h2>
      <Swiper
        spaceBetween={30}
        slidesPerView={1}
        className='my-20'

        loop={true} // Ensure loop is enabled
        autoplay={{
          delay: 3000, // Time in ms before the next slide
          disableOnInteraction: false, // Continue autoplay after user interactions
        }}
        modules={[Autoplay]} // Import the modules here
      >
        {testimonials.map((testimonial, index) => (
          <SwiperSlide key={index}>
            <div className="p-4 space-y-10 flex justify-center items-center flex-col w-9/12 mx-auto ">
              <p className="text-xl text-center" >"{testimonial.review}"</p>
              <p className="font-bold text-center">- {testimonial.name}</p>
            </div>
          </SwiperSlide>
        ))}
      </Swiper>
    </div>
  );
}
